local EMCglobalbuffer = Class(function(self, inst)
    self.inst = inst
    self.EMC = 0
	self.maxEMC = 0
end)

function EMCglobalbuffer:AddInt(value)
	if self.EMC >= self.maxEMC then
		return 0
	end
	
	if self.EMC + value > self.maxEMC then
		value = self.maxEMC - self.EMC
	end
	
	self.EMC = self.EMC + value
	return value
end

function EMCglobalbuffer:AddBool(value)
	if self.EMC + value > self.maxEMC then
		return false
	end
	
	self.EMC = self.EMC + value
	return true
end

function EMCglobalbuffer:GetBool(value)
	if self.EMC < value then
		return false
	end
	
	self.EMC = self.EMC - value
	return true
end


function EMCglobalbuffer:AddToGlobal(value)
	if self.EMC <= 0 or EMCVALUE >= MAXEMCVALUE then
		return
	end
	
	if self.EMC < value then
		value = self.EMC
	end
	
	if value + EMCVALUE > MAXEMCVALUE then
		value = MAXEMCVALUE - EMCVALUE
	end
	
	EMCVALUE = EMCVALUE + value
	self.EMC = self.EMC - value
end

function EMCglobalbuffer:AddFromGlobal(value,minvalue)
	local MinValue = minvalue or 0
	if self.EMC >= self.maxEMC then
		return
	end
	
	if EMCVALUE - MinValue < value then
		value = EMCVALUE - MinValue
	end
	if value + self.EMC > self.maxEMC then
		value = self.maxEMC - self.EMC
	end
	EMCVALUE = EMCVALUE - value
	self.EMC = self.EMC + value
end

function EMCglobalbuffer:BalanceGlobal(value) --Batteries
	if EMCVALUE < MAXEMCVALUE / 2 then
		if value > self.EMC then
			value = self.EMC
		end
		if value > MAXEMCVALUE / 2 - EMCVALUE then
			value = MAXEMCVALUE / 2 - EMCVALUE
		end
		self.EMC = self.EMC - value
		EMCVALUE = EMCVALUE + value
	else
		if value > self.maxEMC - self.EMC then
			value = self.maxEMC - self.EMC
		end
		if value > EMCVALUE - MAXEMCVALUE / 2 then
			value = EMCVALUE - MAXEMCVALUE / 2
		end
		self.EMC = self.EMC + value
		EMCVALUE = EMCVALUE - value
	end
end

function EMCglobalbuffer:OnSave()
	local saveData = {}
	saveData["EMC"] = self.EMC
	return saveData
end

function EMCglobalbuffer:OnLoad(data)
	self.EMC = data["EMC"] or 0
	print("bufferEMC: "..self.EMC)
end



return EMCglobalbuffer